function send=SendOSCMessage(address,port,head,data)

%address
%port
%head
%data
% function send=SendOSCMessage(address,port,head,data)
% Encapsulate head and data in OSC protocol then send it with UPD 
% UDP function used is pnet from TCP_UDP_IP toolbox
% INPUT:
% - address: string with IP address (ex: 10.104.11.14)
% - port: int, port number to connect, default= 7770
% - head: head of the OSC protocol must start with '/'
% - data: float vector of data (single matlab type)
% OUTPUT: 
% - size: the size of the sent data
tic
daze=max(size(data));
pnet('closeall');
%display('alrededor')
udp=pnet('udpsocket',3333); %default port to send data. should be changed
pnet(udp,'write',head);
temp1=mod(max(size(head)),4); % check number of zero to add
temp2=4-temp1-1; % number of zero to add
pnet(udp,'write',uint8(0)); % mandatory zero to finish the string
for i=1:temp2 % add zero at the end to get a multiple of 4
    pnet(udp,'write',uint8(0));
end
pnet(udp,'write',','); % comma to start the type tag
for i=1:daze
    pnet(udp,'write','f'); % number of float to write
end
pnet(udp,'write',uint8(0)); % mandatory zero to finish the typetag string
temp1=mod(daze+2,4); % check number of zero to add
if temp1>0
    temp2=4-temp1; % number of zero to add
    for i=1:temp2 % add zero at the end to get a multiple of 4
        pnet(udp,'write',uint8(0));
    end 
end
for i=1:daze % write the data
    pnet(udp,'write',single(data(i)));
end
send=pnet(udp,'writepacket',address,port);
mic = size(send);